SET SQL_SAFE_UPDATES=0;

SET @dtproviderId=(SELECT id FROM dtprovider WHERE `dataProviderName`='SUBMIT_APPLICATION_PAY_NOW_BUZZ_PARENT_RECIPIENT');

UPDATE `sql_dtprovider`
SET `sqlQuery` = "SELECT 
    T1.id AS ID,
    T4.`firstName` AS FIRST_NAME,
    T4.`lastName` AS LAST_NAME,
    T6.`emailId` AS EMAIL_ID,
    T6.`mobileNumber` AS MOBILE_NO,
    T6.`mobileCountryCode` AS MOBILE_CODE,
    T6.`firstName` AS PARENT_FIRSTNAME,
    T6.`lastName` AS PARENT_LASTNAME,
    T3.`code` AS APPLICATION_CODE,
    T8.displayName AS ACADEMY_NAME_LOCATION,
    CONCAT(T13.addressText,' ',T14.cityName,', ',T15.countryName,', ',T16.countryRegionName) AS ACADEMY_LOCATION_ADDRESS,
    CONCAT(T13.phoneCountryCode,'-',T13.phoneNo) AS ACADEMY_LOCATION_PHONE_NO,
    T13.primaryeEmailId AS ACADEMY_LOCATION_EMAIL_ID,
    T8.academyName AS ACADEMY_NAME,
    T9.programName AS PROGRAM_NAME,
    T11.batchName AS BATCH_NAME,
    T19.printName AS LEAD_OWNER_NAME,
    T19.emailId AS OWNER_EMAIL_ID,
    CONCAT(T19.mobileCountryCode,
            ' ',
            T19.mobileNumber) AS OWNER_MOBILE_NO,
    (CASE
        WHEN
            T8.logoUrl IS NULL
                AND org.orgUrl IS NOT NULL
        THEN
            CONCAT(org.orgUrl,
                    '/',
                    'emailer/images/logo_default_image.png')
        WHEN
            T8.logoUrl IS NULL
                AND org.orgUrl IS NULL
        THEN
            'https://www.serosoft.com/mailer/academiaerp_logo_red.png'
        ELSE CONCAT(org.orgUrl, '/', T8.logoUrl)
    END) AS LOGO_URL,
    (CASE
        WHEN
            T8.headerUrl IS NOT NULL
                AND org.orgUrl IS NOT NULL
        THEN
            CONCAT(org.orgUrl, '/', T8.headerUrl)
        ELSE NULL
    END) AS HEADER_URL
FROM
    external_users T1
        LEFT JOIN
    external_user_association T2 ON T2.externalUserId = T1.id
        LEFT JOIN
    application T3 ON T3.id = T2.applicationId
        LEFT JOIN
    applicant_person T4 ON T4.id = T3.applicantPersonId
        LEFT OUTER JOIN
    applicant_person_relationships T5 ON T5.applicantPersonId = T4.id AND T5.relationship = 'FATHER'
        LEFT JOIN
    applicant_person T6 ON T6.id = T5.relatedApplicantPersonId
        LEFT JOIN
    application_program T7 ON T7.applicationId = T3.id
		LEFT OUTER JOIN
	programs T9 ON T9.id = T7.programId
		LEFT JOIN
    prog_batch_seat_config T10 ON T10.id=T7.progBatchSeatConfigId
		LEFT JOIN
    batches T11 ON T11.id=T10.programBatchId
        LEFT OUTER JOIN
    academy_location T8 ON T8.id = T7.academyLocationId
		LEFT OUTER JOIN
    academy_location_addresses T12 ON T12.academyLocationId = T8.id
		LEFT OUTER JOIN
    address T13 ON T13.id = T12.addressId && T13.addressTypeId=10
		LEFT OUTER JOIN
	city T14 ON T14.id = T13.cityId
		LEFT OUTER JOIN
	country T15 ON T15.id = T14.countryId
		LEFT OUTER JOIN
	country_region T16 ON T16.id = T14.countryRegionId
		LEFT OUTER JOIN
    users T17 ON T17.id = T3.applicationOwner
        LEFT JOIN
    staffs T18 ON T18.userId = T17.id
        LEFT JOIN
    persons T19 ON T19.id = T18.personId
        LEFT OUTER JOIN
    organizations org ON org.id = (SELECT 
            MAX(id)
        FROM
            organizations)
WHERE
    T1.id IN (namedParams) group by T1.id",
    `jsonString` ='{
    "id": 1,
    "searchResultViewColumns": [
        {
            "id": 2,
            "value": "firstName",
            "resultKey": "FIRST_NAME",
            "displayCode": "",
            "displayOrder": 1
        },
        {
            "id": 3,
            "value": "lastName",
            "resultKey": "LAST_NAME",
            "displayCode": "",
            "displayOrder": 2
        },
        {
            "id": 4,
            "value": "emailId",
            "resultKey": "EMAIL_ID",
            "displayCode": "",
            "displayOrder": 3
        },
        {
            "id": 5,
            "value": "mobileNumber",
            "resultKey": "MOBILE_NO",
            "displayCode": "",
            "displayOrder": 4
        },{
            "id": 6,
            "value": "applicationCode",
            "resultKey": "APPLICATION_CODE",
            "displayCode": "",
            "displayOrder": 5
        },
        {
            "id": 7,
            "value": "logoUrl",
            "resultKey": "LOGO_URL",
            "displayCode": "",
            "displayOrder": 6
        },
        {
            "id": 8,
            "value": "headerUrl",
            "resultKey": "HEADER_URL",
            "displayCode": "",
            "displayOrder": 7
        },
        {
            "id": 9,
            "value": "displayName",
            "resultKey": "ACADEMY_NAME_LOCATION",
            "displayCode": "",
            "displayOrder": 8
        },
        {
            "id": 10,
            "value": "Academy Location Address",
            "resultKey": "ACADEMY_LOCATION_ADDRESS",
            "displayCode": "",
            "displayOrder": 9
        },
        {
            "id": 11,
            "value": "Academy Location Phone No.",
            "resultKey": "ACADEMY_LOCATION_PHONE_NO",
            "displayCode": "",
            "displayOrder": 10
        },
        {
            "id": 12,
            "value": "Academy Location Email Id",
            "resultKey": "ACADEMY_LOCATION_EMAIL_ID",
            "displayCode": "",
            "displayOrder": 11
        },
        {
            "id": 13,
            "value": "academyName",
            "resultKey": "ACADEMY_NAME",
            "displayCode": "",
            "displayOrder": 12
        },		
        {
            "id": 14,
            "value": "firstName",
            "resultKey": "PARENT_FIRSTNAME",
            "displayCode": "",
            "displayOrder": 13
        },
		{
            "id": 15,
            "value": "lastName",
            "resultKey": "PARENT_LASTNAME",
            "displayCode": "",
            "displayOrder": 14
        },
        {
            "id": 16,
            "value": "Program Name",
            "resultKey": "PROGRAM_NAME",
            "displayCode": "",
            "displayOrder": 15
        },
        {
            "id": 17,
            "value": "Batch Name",
            "resultKey": "BATCH_NAME",
            "displayCode": "",
            "displayOrder": 16
        },
        {
            "id": 18,
            "value": "Lead Owner Name",
            "resultKey": "LEAD_OWNER_NAME",
            "displayCode": "",
            "displayOrder": 17
        },
        {
            "id": 19,
            "value": "Owner EmailId",
            "resultKey": "OWNER_EMAIL_ID",
            "displayCode": "",
            "displayOrder": 18
        },
        {
            "id": 20,
            "value": "Owner Mobile No",
            "resultKey": "OWNER_MOBILE_NO",
            "displayCode": "",
            "displayOrder": 19
        }
    ]
}' WHERE (`dataProviderId` = @dtproviderId);

SET SQL_SAFE_UPDATES=1;